<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Method not allowed', null, 405);
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Validate required fields
$refreshToken = $input['refresh_token'] ?? '';

if (empty($refreshToken)) {
    sendResponse(false, 'Refresh token is required', null, 400);
}

try {
    // Verify refresh token
    $payload = verifyJWT($refreshToken);
    
    if (!$payload) {
        sendResponse(false, 'Invalid or expired refresh token', null, 401);
    }
    
    $userId = $payload['user_id'];
    
    // Get user details
    $db = getDBConnection();
    $stmt = $db->prepare("
        SELECT id, email, phone, is_admin, is_banned
        FROM users
        WHERE id = ?
    ");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user || $user['is_banned']) {
        sendResponse(false, 'User not found', null, 404);
    }

    // Generate new access token
    $accessToken = generateJWT($user['id'], $user['email'] ?? $user['phone'], $user['is_admin']);
    
    // Optionally generate new refresh token
    $newRefreshToken = generateRefreshToken($user['id']);
    
    // Return new tokens
    sendResponse(true, 'Token refreshed successfully', [
        'access_token' => $accessToken,
        'refresh_token' => $newRefreshToken,
        'token_type' => 'Bearer',
        'expires_in' => JWT_EXPIRY_SECONDS
    ]);
    
} catch (Exception $e) {
    error_log("Refresh token error: " . $e->getMessage());
    sendResponse(false, 'Token refresh failed', null, 401);
}


