<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendErrorResponse('Method not allowed', 405);
}

try {
    // Verify JWT token
    $userId = verifyJWT();
    
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Validate required fields
    if (!isset($input['post_id'])) {
        sendErrorResponse('Post ID is required', 400);
    }
    
    if (!isset($input['comment']) || trim($input['comment']) === '') {
        sendErrorResponse('Comment is required', 400);
    }
    
    $postId = (int)$input['post_id'];
    $comment = trim($input['comment']);
    
    // Get database connection
    $db = getDBConnection();
    
    // Check if post exists
    $stmt = $db->prepare("SELECT id FROM community_posts WHERE id = ?");
    $stmt->execute([$postId]);
    if (!$stmt->fetch()) {
        sendErrorResponse('Post not found', 404);
    }
    
    // Insert comment
    $stmt = $db->prepare("
        INSERT INTO community_comments (post_id, user_id, comment)
        VALUES (?, ?, ?)
    ");
    
    $stmt->execute([
        $postId,
        $userId,
        $comment
    ]);
    
    $commentId = $db->lastInsertId();
    
    // Get the created comment
    $stmt = $db->prepare("
        SELECT 
            c.id, c.comment, c.created_at, c.updated_at,
            u.id as user_id, u.name as user_name, u.email as user_email
        FROM community_comments c
        INNER JOIN users u ON c.user_id = u.id
        WHERE c.id = ?
    ");
    $stmt->execute([$commentId]);
    $commentData = $stmt->fetch(PDO::FETCH_ASSOC);
    
    sendSuccessResponse('Comment created successfully', $commentData);
    
} catch (Exception $e) {
    sendErrorResponse($e->getMessage(), 500);
}


