<?php
/**
 * Create Crop
 * POST /api/farm/create-crop.php
 */

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');
$userId = requireAuth();

try {
    $db = getDBConnection();
    
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (empty($data['crop_name'])) {
        sendResponse(false, 'Crop name is required');
    }
    
    if (empty($data['crop_type'])) {
        sendResponse(false, 'Crop type is required');
    }
    
    // Validate farm_section_id if provided
    if (!empty($data['farm_section_id'])) {
        $stmt = $db->prepare("SELECT id FROM farm_sections WHERE id = ? AND user_id = ?");
        $stmt->execute([$data['farm_section_id'], $userId]);
        if (!$stmt->fetch()) {
            sendResponse(false, 'Invalid farm section ID');
        }
    }
    
    $stmt = $db->prepare("
        INSERT INTO crops (
            user_id, farm_section_id, crop_name, crop_type, variety,
            planting_date, expected_harvest_date, status, notes
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    
    $stmt->execute([
        $userId,
        $data['farm_section_id'] ?? null,
        $data['crop_name'],
        $data['crop_type'],
        $data['variety'] ?? null,
        $data['planting_date'] ?? null,
        $data['expected_harvest_date'] ?? null,
        $data['status'] ?? 'growing',
        $data['notes'] ?? null
    ]);
    
    $cropId = $db->lastInsertId();
    
    $stmt = $db->prepare("
        SELECT 
            c.id, c.crop_name, c.crop_type, c.variety, c.planting_date,
            c.expected_harvest_date, c.actual_harvest_date, c.status, c.notes,
            c.created_at, c.updated_at,
            fs.id as farm_section_id, fs.section_name
        FROM crops c
        LEFT JOIN farm_sections fs ON c.farm_section_id = fs.id
        WHERE c.id = ?
    ");
    
    $stmt->execute([$cropId]);
    $crop = $stmt->fetch(PDO::FETCH_ASSOC);
    
    sendResponse(true, 'Crop created successfully', ['crop' => $crop]);
    
} catch (PDOException $e) {
    error_log('Database error: ' . $e->getMessage());
    sendResponse(false, 'Failed to create crop');
} catch (Exception $e) {
    error_log('Error: ' . $e->getMessage());
    sendResponse(false, 'An error occurred');
}


