<?php
/**
 * Create Farm Section
 * POST /api/farm/create-section.php
 */

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');
$userId = requireAuth();

try {
    $db = getDBConnection();
    
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (empty($data['section_name'])) {
        sendResponse(false, 'Section name is required');
    }
    
    if (empty($data['area_size'])) {
        sendResponse(false, 'Area size is required');
    }
    
    if (empty($data['area_unit'])) {
        sendResponse(false, 'Area unit is required');
    }
    
    $stmt = $db->prepare("
        INSERT INTO farm_sections (
            user_id, section_name, area_size, area_unit, soil_type, notes
        ) VALUES (?, ?, ?, ?, ?, ?)
    ");
    
    $stmt->execute([
        $userId,
        $data['section_name'],
        $data['area_size'],
        $data['area_unit'],
        $data['soil_type'] ?? null,
        $data['notes'] ?? null
    ]);
    
    $sectionId = $db->lastInsertId();
    
    $stmt = $db->prepare("
        SELECT 
            id, section_name, area_size, area_unit, soil_type, notes, created_at, updated_at
        FROM farm_sections
        WHERE id = ?
    ");
    
    $stmt->execute([$sectionId]);
    $section = $stmt->fetch(PDO::FETCH_ASSOC);
    
    sendResponse(true, 'Farm section created successfully', ['section' => $section]);
    
} catch (PDOException $e) {
    error_log('Database error: ' . $e->getMessage());
    sendResponse(false, 'Failed to create farm section');
} catch (Exception $e) {
    error_log('Error: ' . $e->getMessage());
    sendResponse(false, 'An error occurred');
}


