<?php
/**
 * Get Farm Sections
 * GET /api/farm/get-sections.php
 */

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');
$userId = requireAuth();

try {
    $db = getDBConnection();
    
    $stmt = $db->prepare("
        SELECT 
            id,
            section_name,
            area_size,
            area_unit,
            soil_type,
            notes,
            created_at,
            updated_at
        FROM farm_sections
        WHERE user_id = ?
        ORDER BY section_name ASC
    ");
    
    $stmt->execute([$userId]);
    $sections = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    sendResponse(true, 'Farm sections retrieved successfully', ['sections' => $sections]);
    
} catch (PDOException $e) {
    error_log('Database error: ' . $e->getMessage());
    sendResponse(false, 'Failed to retrieve farm sections');
} catch (Exception $e) {
    error_log('Error: ' . $e->getMessage());
    sendResponse(false, 'An error occurred');
}


