<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendErrorResponse('Method not allowed', 405);
}

try {
    // Verify JWT token
    $userId = verifyJWT();
    
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Validate required fields
    if (!isset($input['request_id'])) {
        sendErrorResponse('Request ID is required', 400);
    }
    
    $requestId = (int)$input['request_id'];
    
    // Get database connection
    $db = getDBConnection();
    
    // Check if request exists and is for this user
    $stmt = $db->prepare("
        SELECT id, user_id, friend_id, status 
        FROM friends 
        WHERE id = ? AND friend_id = ?
    ");
    $stmt->execute([$requestId, $userId]);
    $request = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$request) {
        sendErrorResponse('Friend request not found', 404);
    }
    
    if ($request['status'] !== 'pending') {
        sendErrorResponse('Friend request already processed', 400);
    }
    
    // Accept the request
    $stmt = $db->prepare("UPDATE friends SET status = 'accepted' WHERE id = ?");
    $stmt->execute([$requestId]);
    
    // Get friend info
    $stmt = $db->prepare("SELECT id, name, email FROM users WHERE id = ?");
    $stmt->execute([$request['user_id']]);
    $friend = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $data = [
        'request_id' => $requestId,
        'friend_id' => $friend['id'],
        'friend_name' => $friend['name'],
        'friend_email' => $friend['email'],
        'status' => 'accepted',
    ];
    
    sendSuccessResponse('Friend request accepted', $data);
    
} catch (Exception $e) {
    sendErrorResponse($e->getMessage(), 500);
}


