<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/jwt.php';
require_once __DIR__ . '/../../includes/helpers.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    sendErrorResponse('Method not allowed', 405);
}

// Get authorization header
$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (empty($authHeader) || !preg_match('/Bearer\s+(.*)$/i', $authHeader, $matches)) {
    sendErrorResponse('Authorization token required', 401);
}

$token = $matches[1];
$decoded = validateJWT($token);

if (!$decoded) {
    sendErrorResponse('Invalid or expired token', 401);
}

$userId = $decoded['user_id'];

// Get harvest ID from query parameter
$harvestId = $_GET['harvest_id'] ?? null;

if (!$harvestId) {
    sendErrorResponse('Harvest ID is required', 400);
}

try {
    // Verify harvest belongs to user
    $stmt = $db->prepare("SELECT id FROM harvests WHERE id = ? AND user_id = ?");
    $stmt->execute([$harvestId, $userId]);
    
    if (!$stmt->fetch()) {
        sendErrorResponse('Harvest not found or access denied', 404);
    }
    
    // Delete harvest
    $stmt = $db->prepare("DELETE FROM harvests WHERE id = ?");
    $stmt->execute([$harvestId]);
    
    sendSuccessResponse('Harvest deleted successfully');
    
} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    sendErrorResponse('Database error occurred', 500);
}


