<?php
/**
 * Delete Task
 * DELETE /api/tasks/delete-task.php
 */

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/jwt.php';

header('Content-Type: application/json');
$userId = requireAuth();

try {
    $db = getDBConnection();
    
    // Get task ID from query parameter
    $taskId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    
    if (empty($taskId)) {
        sendResponse(false, 'Task ID is required');
    }
    
    // Check if task exists and belongs to user
    $stmt = $db->prepare("SELECT id FROM tasks WHERE id = ? AND user_id = ?");
    $stmt->execute([$taskId, $userId]);
    if (!$stmt->fetch()) {
        sendResponse(false, 'Task not found');
    }
    
    // Delete task (cascade will delete related reminders)
    $stmt = $db->prepare("DELETE FROM tasks WHERE id = ? AND user_id = ?");
    $stmt->execute([$taskId, $userId]);
    
    sendResponse(true, 'Task deleted successfully');
    
} catch (PDOException $e) {
    error_log('Database error: ' . $e->getMessage());
    sendResponse(false, 'Failed to delete task');
} catch (Exception $e) {
    error_log('Error: ' . $e->getMessage());
    sendResponse(false, 'An error occurred');
}


